﻿/*
	VERSION:		1.2
		
		
	USAGE 1:
		doubleClick = new DoubleClick();
		doubleClick.onDoubleClick = function()
		{
			trace("double click");
		}
	
	
	USAGE 2:
		doubleClick = new DoubleClick();
		doubleClick.addListener( this );
		this.onDoubleClick = function()
		{
			trace("double click");
		}
*/
class DoubleClick
{
	var maxDistance = 16;				// pixels.  How close the 2 clicks need to be to each other
	var maxDelay = 1000/4.5;			// milliseconds.  How fast the double-click needs to be, to be valid
	var oldX:Number;
	var oldY:Number;
	var broadcastMessage:Function;	// Allows events to be broadcast
	var onDoubleClick:Function;			// externally-defined function
	function DoubleClick()
	{
		AsBroadcaster.initialize( this );
		Mouse.addListener( this );
		this.timeOut( this );
	}// CONSTRUCTOR
	
	function onMouseUp()
	{
		// if this click is near the previous one  &  timeOut hasn't expired
		var newX = _root._xmouse;
		var newY = _root._ymouse;
		var diffX = newX - this.oldX;
		var diffY = newY - this.oldY;
		var clickDistance = Math.sqrt( (diffX*diffX) + (diffY*diffY) );
		if( clickDistance < this.maxDistance)
		{
			this.onDoubleClick();
			this.broadcastMessage( "onDoubleClick" );
			this.timeOut( this );
		}else{
			// remember this click location
			this.oldX = newX;
			this.oldY = newY;
			// set double-click timeOut
			_global.setTimeout( timeOut, maxDelay, this );		// calls timeOut() 1/4 of a second later
		}
	}// click()
	
	function timeOut( _this )
	{
		// _this   is needed because this function is called by setTimeout(),   a _global function which has NO access to this class's variables!   
		// ...so a reference is needed to access them.
		_this.oldX = Math.floor(Math.random()*99999);
		_this.oldY = Math.floor(Math.random()*99999);
	}// timeOut()
}// DoubleClick
